﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.Common;

namespace MicroRWD.UI.QT
{
    public partial class MicroRWD_MemoryPanel : UserControl
    {
        #region Constructor

        public MicroRWD_MemoryPanel()
        {
            InitializeComponent();

            // Load MicroRWD Memory Definitions
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "00", "Tag Polling Rate (x 2.5ms)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "01", "RF ON/OFF lock (0x55 = ON = default)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "02", "*Reserved* (Checksum)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "03", "H1 Encrypt ON/OFF byte (0x00 = OFF)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "04", "H1 Encryption seed (MS byte)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "05", "H1 Encryption seed (Byte 2)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "06", "H1 Encryption seed (Byte 1)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "07", "H1 Encryption seed (LS Byte)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "08", "RWD PASSWORD (MS byte) (default 0x4D)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "09", "RWD PASSWORD (Byte 2) (default 0x49)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "0A", "RWD PASSWORD (Byte 3) (default 0x4B)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "0B", "RWD PASSWORD (LS byte) (default 0x52)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "0C", "*Reserved*" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "0D", "TAG PASSWORD (MS byte) (default 0xAA)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "0E", "TAG PASSWORD (Byte 1) (default 0x48)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "0F", "TAG PASSWORD (LS byte) (default 0x52)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "10", "EM400X Option byte (0x00=MC, 0x01=EM)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "11", "READER TYPE (01=H2, 02=H1, 03=EM/MC)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "12", "*Reserved*" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "13", "*Reserved*" }));

            for ( UInt16 i = 0x0014; i <= 0x00FF; i += 4 )
            {
                microRWD_ListView.Items.Add(new ListViewItem(new string[] { (i + 0).ToString("X2"), "Tag " + i.ToString() + " (MS byte)" }));
                microRWD_ListView.Items.Add(new ListViewItem(new string[] { (i + 1).ToString("X2"), "Tag " + i.ToString() + " (Byte 2)" }));
                microRWD_ListView.Items.Add(new ListViewItem(new string[] { (i + 2).ToString("X2"), "Tag " + i.ToString() + " (Byte 1)" }));
                microRWD_ListView.Items.Add(new ListViewItem(new string[] { (i + 3).ToString("X2"), "Tag " + i.ToString() + " (LS byte)" }));
            }

            // Select first item by default
            microRWD_ListView.Items[0].Selected = true;
        }

        #endregion


        #region Event Handlers

        private void writeToMicroRWD_Button_Click(object sender, EventArgs e)
        {
            writeToMicroRWD();
        }

        private void microRWD_ListView_DoubleClick(object sender, EventArgs e)
        {
            writeToMicroRWD();
        }

        private void writeToMicroRWD()
        {
            // Establish memory location
            if (microRWD_ListView.SelectedIndices.Count > 0)
            {
                WriteToMicroRWD_MemoryForm form = new WriteToMicroRWD_MemoryForm(1, microRWD_ListView, 1, Program.Controller.Reader);
                form.ShowDialog();
            }
        }

        private void microRWD_ListView_SelectedIndexChanged(object sender, EventArgs e)
        {
            // Check for selected index
            if (microRWD_ListView.SelectedIndices.Count > 0)
            {
                // Ensure selected item is visible
                microRWD_ListView.EnsureVisible(microRWD_ListView.SelectedIndices[0]);
            }
        }

        #endregion

    }
}
